<?php

namespace App\Http\Requests\Access;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class PermissionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'category_id' => 'required',
                    'title' => 'required|max:250',
                    'name' => 'required|max:191'
                ];
            }
            case 'PATCH':
            {
                $id=$this->request->get('id');
                return [
                    'category_id' => 'required',
                    'title' => 'required|max:250',
                    'name' => 'required|max:191',
                ];
            }
            default:
                break;
        }
    }
}
