<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class LowerCaseUrl
{
    /**
     * درخواست ورودی را مدیریت کند.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request)  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $url_orginal = urldecode($request->path());
        $string=preg_match('/^[^\x{600}-\x{6FF}]+$/u', $url_orginal);
        if ($string > 0)
        {
            $url_lower = strtolower($request->path());
            $url=strtolower(urldecode($request->fullUrl()));
            $preg_match="/uploads/";
//        dd($url_orginal != $url_lower);
            // بخش تصاویر را با استفاده از یک عبارت باقاعده مستثنی کنید
            if (!preg_match($preg_match, $url_lower) && $url_orginal != $url_lower) {
                header("Location: $url", true, 301);
                exit();
            }
        }
        return $next($request);
    }
}