<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/admin/profile';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    public function username()
    {
        $loginInput = request()->input('username');

        if (filter_var($loginInput, FILTER_VALIDATE_EMAIL)) {
            request()->merge(['email' => $loginInput]);
            return 'email';
        }

        request()->merge(['username' => $loginInput]);
        return 'username';
    }


//    protected function authenticated(Request $request, $user)
//    {
//        if ($user->status === 'blocked') {
//            Auth::logout();
//            return redirect()->back()->with(['err_message' => 'وضعیت پنل شما به حالت مسدود درآمده']);
//        }
//
//        $role = strtolower(trim($user->role));
//        if ($role === 'admin' || 'developer') {
//            return redirect('/admin/profile');
//        } elseif ($role === 'teacher') {
//            return redirect('/teacher/profile');
//        } elseif ($role === 'student') {
//            return redirect('/student/profile');
//        }
//
//
//        return redirect('/');
//    }

}
