<?php

namespace App\Http\Controllers\Admin\Setting;

use App\Http\Controllers\Controller;
use App\Http\Requests\Setting\UploadSitemapRequest;
use App\Models\UploadSitemap;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Spatie\Permission\Models\Permission;

class UploadSitemapController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return 'آپلود فایل';
                break;
            case 'url_back':
                return route('admin.upload-sitemaps.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:upload_sitemap_list', ['only' => ['index']]);
        $this->middleware('permission:upload_sitemap_edit', ['only' => ['update']]);
    }

    public function index()
    {
        $items = UploadSitemap::orderByDesc('id')->get();
        return view('admin.setting.upload_sitemaps.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    public function show($id)
    {
    }

    public function create()
    {
        //
    }

    public function store(UploadSitemapRequest $request)
    {
        //
    }

    public function edit($id)
    {
        //
    }

    public function update(UploadSitemapRequest $request, $id)
    {
        $item = UploadSitemap::findOrFail($id);
        try {
            if ($request->hasFile('file')) {
                $request->file->move('./', 'sitemap.xml');
                $item->update();
            }
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت ویرایش شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    public function destroy($id)
    {
        //
    }
}
