<?php

namespace App\Http\Controllers\Admin\Setting;

use App\Models\Lang;
use App\Models\SiteWord;
use App\Models\Photo;
use App\Http\Requests\Setting\SiteWordRequest;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;

class SiteWordController extends Controller
{
    public function controller_title($type)
    {
        switch ($type)
        {
            case 'index':
                return 'واژه های ثابت';
                break;
            case 'create':
                return 'افزودن واژه';
                break;
            case 'edit':
                return 'ویرایش واژه';
                break;
            case 'url_back':
                return route('admin.site-word.index');
                break;
            default:
                return '';
                break;
        }
    }
    public function __construct()
    {
        $this->middleware('permission:site_word_list', ['only' => ['index','show']]);
        $this->middleware('permission:site_word_create', ['only' => ['create','store']]);
        $this->middleware('permission:site_word_edit', ['only' => ['edit','update']]);
        $this->middleware('permission:site_word_delete', ['only' => ['destroy']]);
        $this->middleware('permission:site_word_status', ['only' => ['status']]);
    }

    public function index()
    {
        $items=SiteWord::orderBy('slug')->get();
//        $all=0;
//        $trans=0;
//        foreach ($items as $item)
//        {
//            if(blank(read_lang_word($item->code,'en')))
//            {
//                $new_l = new Lang();
//                $new_l->col_name = 'word';
//                $new_l->lang = 'en';
//                $new_l->text = strtoupper(translate('fa','en',$item->word));
//                $item->langs()->save($new_l);
//                $trans++;
//            }
//            $all++;
//        }
//        dd($all,$trans);
        return view('admin.setting.site_word.index', compact('items'), ['title' => $this->controller_title('index')]);
    }
    public function show($id)
    {

    }
    public function create()
    {
        if(!auth()->user()->hasRole('developer'))
        {
            abort(404);
        }
        $url_back=$this->controller_title('url_back');
        return view('admin.setting.site_word.create',compact('url_back'), ['title' => $this->controller_title('create')]);
    }
    public function store(SiteWordRequest $request)
    {
        try {
            $item = SiteWord::create([
                'slug' => $request->slug,
                'word' => $request->word,
            ]);
            store_lang($item,$request,['word'],'create');

            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت افزوده شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای افزودن به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
    public function edit($id)
    {
        $url_back=$this->controller_title('url_back');
        $item=SiteWord::findOrFail($id);
        return view('admin.setting.site_word.edit',compact('url_back','item'), ['title' => $this->controller_title('edit')]);
    }
    public function update(SiteWordRequest $request,$id)
    {
        $item=SiteWord::findOrFail($id);
        try {
            SiteWord::where('id',$id)->update([
                'slug' => $request->slug??$item->slug,
                'word' => $request->word,
            ]);
            store_lang($item,$request,['word'],'edit');

            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت ویرایش شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
    public function destroy($id)
    {
        $item=SiteWord::findOrFail($id);
        try {
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت حذف شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای حذف به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

}
