<?php

namespace App\Http\Controllers\Admin\Setting;

use App\Http\Controllers\Controller;
use App\Http\Requests\Setting\SettingRequest;
use App\Models\Photo;
use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Spatie\Permission\Models\Permission;

class SettingController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return 'تنظیمات سایت';
                break;
            case 'create':
                return 'افزودن  ندارد';
                break;
            case 'edit':
                return 'ویرایش تنظیمات سایت';
                break;
            case 'url_back':
                return route('admin.setting.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:setting_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:setting_edit', ['only' => ['edit', 'update']]);
    }

    public function index()
    {
        $items = Setting::orderBy('id')->get();
        return view('admin.setting.site.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    public function show($id)
    {

    }

    public function create()
    {

    }

    public function store(SettingRequest $request)
    {

    }

    public function edit($id)
    {
        $url_back = $this->controller_title('url_back');
        $item = Setting::findOrFail($id);
        return view('admin.setting.site.edit', compact('url_back', 'item'), ['title' => $this->controller_title('edit')]);
    }

    public function update(SettingRequest $request, $id)
    {
        $item = Setting::findOrFail($id);
        try {
            Setting::where('id', $id)->update([
                'title' => $request->title,
                'description' => $request->description,
            ]);
            //edit logo
            if ($request->hasFile('logo')) {
                if ($item->logo) {
                    if (is_file($item->logo->path)) {
                        File::delete($item->logo->path);
                        delete_directory($item->logo->path);
                    }
                    $item->logo->delete();
                }
                $photo = new Photo();
                $photo->type = 'logo';
                $photo->path = file_store($request->logo, 'assets/admin/uploads/setting/site' . '/');
                $item->logo()->save($photo);
            }
            //edit icon
            if ($request->hasFile('icon')) {
                if ($item->icon) {
                    if (is_file($item->icon->path)) {
                        File::delete($item->icon->path);
                        delete_directory($item->icon->path);
                    }
                    $item->icon->delete();
                }
                $photo = new Photo();
                $photo->type = 'icon';
                $photo->path = file_store($request->icon, 'assets/admin/uploads/setting/site' . '/');
                $item->icon()->save($photo);
            }
            //edit header
            if ($request->hasFile('header')) {
                if ($item->header) {
                    if (is_file($item->header->path)) {
                        File::delete($item->header->path);
                        delete_directory($item->header->path);
                    }
                    $item->header->delete();
                }
                $photo = new Photo();
                $photo->type = 'header';
                $photo->path = file_store($request->header, 'assets/admin/uploads/setting/site' . '/');
                $item->header()->save($photo);
            }

            store_lang($item, $request, ['title', 'description', 'keywords'], 'edit');

            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت ویرایش شد');
        } catch (\Exception $e) {
            dd($e);
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
    }


    public function delete_pic($id)
    {
        $item = Photo::findOrFail($id);
        try {
            if (is_file($item->path)) {
                File::delete($item->path);
                delete_directory($item->path);
            }
            $item->delete();
            return redirect()->back()->with('flash_message', 'اطلاعات با موفقیت حذف شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای حذف به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    public function delete_photo()
    {
        $item = Photo::findOrFail(request()->photo_id);

        if (is_file($item->path)) {
            File::delete($item->path);
            delete_directory($item->path);
        }
        $item->delete();
        return response()->json([
            'status' => 'success',
            'res' => request()->photo_id
        ], 200);
    }

    public function destroy()
    {

    }
}
