<?php

namespace App\Http\Controllers\Admin\Setting;

use App\Models\InstructorProfile;
use App\Models\User;
use App\Models\Photo;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\DB;

class ProfileController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:profile_list', ['only' => ['index','show']]);
        $this->middleware('permission:profile_edit', ['only' => ['edit','update']]);
    }
    public function show()
    {
        $item=User::findOrFail(Auth::user()->id);
        return view('admin.setting.profile.show', compact('item'));
    }

    public function update(Request $request, $id)
    {
        $item = User::findOrFail($id);
        $this->validate($request, [

            'password' => 'nullable|min:6|confirmed',
            'photo' => "nullable|image|mimes:jpeg,jpg,png|max:2048",
        ]);
        try {
            return DB::transaction(function () use ($request, $item){
                if ($request->input('password') != null and $request->input('password') != '') {
                    $item->password = $request->input('password');
                }
                $item->update();

                //edit User photo
                if ($request->hasFile('photo')) {
                    if($item->photo)
                    {
                        if(is_file($item->photo->path))
                        {
                            File::delete($item->photo->path);
                            delete_directory($item->photo->path);
                        }
                        $item->photo->delete();
                    }
                    $photo = new Photo();
                    $photo->type = 'photo';
                    $photo->path = file_store($request->photo, 'assets/admin/uploads/setting/profile' . '/');
                    $item->photo()->save($photo);
                }

                if (! $item->hasRole('student')) {
                    InstructorProfile::updateOrCreate(
                        ['user_id' => $item->id],
                        [
                            'degree' => $request->degree,
                            'university'=>$request->university,
                            'bio' => $request->bio,
                            'experience_years'=>$request->experience_years,
                            'whatsapp' => $request->whatsapp,
                            'instagram'=>$request->instagram,
                            'facebook' => $request->facebook,
                            'twitter'=>$request->twitter,
                            'linkedin'=>$request->linkedin,
                            'youtube' => $request->youtube,
                            'telegram'=>$request->telegram,
                         ]
                    );


                }


                return redirect()->back()->with('flash_message', 'اطلاعات با موفقیت ویرایش شد');
            });
            }catch (\Exception $e) {
                dd($e->getMessage());
                return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
            }

    }


}
