<?php

namespace App\Http\Controllers\Admin\Setting;

use App\Http\Controllers\Controller;
use App\Http\Requests\Setting\PageHeaderRequest;
use App\Models\PageHeader;
use App\Models\Photo;
use App\Models\Setting;
use Illuminate\Support\Facades\File;
use Illuminate\Http\Request;

class PageHeaderController extends Controller
{
    public function controller_title($type)
    {
        switch ($type)
        {
            case 'index':
                return 'تنظیمات هدر سایت';
                break;
            case 'create':
                return 'افزودن هدر سایت';
                break;
            case 'edit':
                return 'ویرایش هدر سایت';
                break;
            case 'url_back':
                return route('admin.page-header.index');
                break;
            default:
                return '';
                break;
        }
    }
    public function __construct()
    {
        $this->middleware('permission:page_header_list', ['only' => ['index','show']]);
        $this->middleware('permission:page_header_create', ['only' => ['create','store']]);
        $this->middleware('permission:page_header_edit', ['only' => ['edit','update']]);
        $this->middleware('permission:page_header_delete', ['only' => ['destroy']]);
    }

    public function index()
    {
        $items= PageHeader::all();
        return view('admin.setting.pageHeader.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $pageList=PageHeader::PAGES;
        return view('admin.setting.pageHeader.create', compact('pageList'), ['title' => $this->controller_title('index')]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(PageHeaderRequest $request)
    {
        try {
            $item = PageHeader::create([
                'page' => $request->page,
                'title' => $request->title,
                'subtitle' => $request->subtitle,
                'text' => $request->text,
            ]);
            //create header
            if ($request->hasFile('header')) {
                $photo = new Photo();
                $photo->type = 'header';
                $photo->path = file_store($request->header, 'assets/admin/uploads/setting/site/header' . '/');
                $item->header()->save($photo);
            }

            store_lang($item, $request, ['title', 'subtitle', 'text'], 'create');

            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت افزوده شد');
        } catch (\Exception $e) {
            dd($e->getMessage());
            return redirect()->back()->withInput()->with('err_message', 'برای افزودن به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit( $id)
    {
        $url_back = $this->controller_title('url_back');
        $item = PageHeader::findOrFail($id);
        $pageList=PageHeader::PAGES;
        return view('admin.setting.pageHeader.edit', compact(['item','url_back','pageList']), ['title' => $this->controller_title('index')]);

    }

    /**
     * Update the specified resource in storage.
     */
    public function update(PageHeaderRequest $request, $id)
    {
        $item = PageHeader::findOrFail($id);
        try {
            PageHeader::where('id', $id)->update([
                'page' => $request->page,
                'title' => $request->title,
                'subtitle' => $request->subtitle,
                'text' => $request->text,
            ]);
            //create header
            if ($request->hasFile('header')) {
                if ($item->header) {
                    if (is_file($item->header->path)) {
                        File::delete($item->header->path);
                        delete_directory($item->header->path);
                    }
                    $item->header->delete();
                }
                $photo = new Photo();
                $photo->type = 'header';
                $photo->path = file_store($request->header, 'assets/admin/uploads/setting/site' . '/');
                $item->header()->save($photo);
            }

            store_lang($item, $request, ['title', 'subtitle', 'text'], 'edit');

            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت ویرایش شد');
        } catch (\Exception $e) {
            dd($e->getMessage());
            return redirect()->back()->withInput()->with('err_message', 'برای افزودن به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy( $id)
    {
        //
    }
}
