<?php

namespace App\Http\Controllers\Admin\Setting;

use App\Http\Controllers\Controller;
use App\Http\Requests\Setting\LangSetRequest;
use App\Models\LangSet;
use App\Models\Photo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Spatie\Permission\Models\Permission;

class LangSetController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return 'زبان های سایت';
                break;
            case 'create':
                return 'افزودن  زبان';
                break;
            case 'edit':
                return 'ویرایش زبان';
                break;
            case 'url_back':
                return route('admin.lang-set.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:lang_set_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:lang_set_create', ['only' => ['create', 'store']]);
        $this->middleware('permission:lang_set_edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:lang_set_delete', ['only' => ['destroy']]);
        $this->middleware('permission:lang_set_status', ['only' => ['status']]);
    }

    public function index()
    {
        $items = LangSet::orderBy('sort')->get();
        return view('admin.setting.lang.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    public function show($id)
    {

    }

    public function create()
    {
        $url_back = $this->controller_title('url_back');
        $sort = LangSet::count() + 1;
        return view('admin.setting.lang.create', compact('url_back', 'sort'), ['title' => $this->controller_title('create')]);
    }

    public function store(LangSetRequest $request)
    {
        try {
            $item = LangSet::create([
                'title' => $request->title,
                'lang' => $request->lang,
                'faker' => $request->faker,
                'align' => $request->align,
                'status' => $request->status,
                'sort' => $request->sort,
                'farsi_font' => $request->farsi_font,
            ]);

            //create photo
            if ($request->hasFile('photo')) {
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/setting/lang-set' . '/');
                $item->photo()->save($photo);
            }
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت افزوده شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای افزودن به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    public function edit($id)
    {
        $url_back = $this->controller_title('url_back');
        $item = LangSet::findOrFail($id);
        return view('admin.setting.lang.edit', compact('url_back', 'item'), ['title' => $this->controller_title('edit')]);
    }

    public function update(LangSetRequest $request, $id)
    {
        $item = LangSet::findOrFail($id);
        try {
            LangSet::where('id', $id)->update([
                'title' => $request->title,
                'lang' => $request->lang,
                'faker' => $request->faker,
                'align' => $request->align,
                'status' => $request->status,
                'sort' => $request->sort,
                'farsi_font' => $request->farsi_font,
            ]);
            //edit photo
            if ($request->hasFile('photo')) {
                if ($item->photo) {
                    if (is_file($item->photo->path)) {
                        File::delete($item->photo->path);
                        delete_directory($item->photo->path);
                    }
                    $item->photo->delete();
                }
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/setting/lang-set' . '/');
                $item->photo()->save($photo);
            }
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت ویرایش شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    public function destroy($id)
    {
        $item = LangSet::findOrFail($id);
        try {
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت حذف شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای حذف به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    public function status($id, $type, $status)
    {
        $item = LangSet::findOrFail($id);
        try {
            $item->$type = $status;
            $item->update();
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت تغیر وضعیت شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای تغیر وضعیت به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
}
