<?php

namespace App\Http\Controllers\Admin\Setting;

use App\Http\Controllers\Controller;
use App\Http\Requests\Setting\FeatureRequest;
use App\Models\CourseFeature;
use Illuminate\Http\Request;

class CourseFeatureController extends Controller
{
    public function controller_title($type)
    {
        switch ($type)
        {
            case 'index':
                return 'چرا ما';
                break;
            case 'create':
                return 'افزودن  بحش چرا ما';
                break;
            case 'edit':
                return 'ویرایش بحش چرا ما';
                break;
            case 'url_back':
                return route('admin.course-feature.index');
                break;
            default:
                return '';
                break;
        }
    }
    public function __construct()
    {
        $this->middleware('permission:course_feature_list', ['only' => ['index','show']]);
        $this->middleware('permission:course_feature_delete', ['only' => ['create','store']]);
        $this->middleware('permission:course_feature_create', ['only' => ['edit','update']]);
        $this->middleware('permission:course_feature_delete', ['only' => ['destroy']]);
    }
    public function index()
    {

        $items=CourseFeature::orderByDesc('sort')->get();
        return view('admin.setting.course_feature.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $url_back=$this->controller_title('url_back');
        return view('admin.setting.course_feature.create',compact('url_back'), ['title' => $this->controller_title('create')]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(FeatureRequest $request)
    {
        try {
            $item = CourseFeature::create([
                'title' => $request->title,
                'icon' => $request->icon,
                'description' => $request->description,
                'status' => $request->status,
                'sort' => $request->sort,
            ]);

            store_lang($item,$request,['title','description', 'status','icon','sort'],'create');
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت افزوده شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای افزودن به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $url_back=$this->controller_title('url_back');
        $item=CourseFeature::findOrFail($id);
        return view('admin.setting.course_feature.edit',compact('url_back','item'), ['title' => $this->controller_title('edit')]);

    }

    /**
     * Update the specified resource in storage.
     */
    public function update(FeatureRequest $request, $id)
    {
        $item=CourseFeature::findOrFail($id);
        try {
            CourseFeature::where('id',$id)->update([
                'title' => $request->title,
                'icon' => $request->icon,
                'description' => $request->description,
                'status' => $request->status,
                'sort' => $request->sort,
            ]);
            store_lang($item,$request,['title','description','status','icon','sort'],'edit');
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت ویرایش شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $item=CourseFeature::findOrFail($id);
        try {
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت حذف شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای حذف به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
}
