<?php

namespace App\Http\Controllers\Admin\Product;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use App\Http\Requests\Product\ProductRequest;
use App\Models\Photo;
use App\Models\Product;
use App\Models\ProductCategory;
use App\Models\ProductAttr;
class ProductController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return 'محصولات';
                break;
            case 'create':
                return 'افزودن محصول';
                break;
            case 'edit':
                return 'ویرایش محصول';
                break;
            case 'attr_list':
                return 'لیست ویژگی های ';
                break;
            case 'url_back':
                return route('admin.product.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:product_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:product_create', ['only' => ['create', 'store']]);
        $this->middleware('permission:product_edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:product_delete', ['only' => ['destroy']]);
        $this->middleware('permission:product_attr', ['only' => ['attr_list','attr_store','attr_sort','attr_destroy']]);
    }

    public function index()
    {
        $items = Product::orderByDesc('id')->get();
        return view('admin.product.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    public function show($id)
    {

    }

    public function create()
    {
        $url_back = $this->controller_title('url_back');
        $cats_id=[];
        $cats = ProductCategory::with('childs')
            ->whereNull('parent_id')
            ->orderBy('sort')->get();
        foreach ($cats as $cat)
        {
            array_push($cats_id,['id'=>$cat->id,'title'=>$cat->title]);
            foreach ($cat->childs as $child)
            {
                array_push($cats_id,['id'=>$child->id,'title'=>$cat->title.' - '.$child->title]);
            }
        }
        return view('admin.product.create', compact('url_back', 'cats_id'), ['title' => $this->controller_title('create')]);
    }

    public function store(ProductRequest $request)
    {
        try {
            $item = Product::create([
                'category_id' => $request->category_id,
                'title' => $request->title,
                'slug' => $request->slug,
                'top_text' => $request->top_text,
                'text' => $request->text,
                'text2' => $request->text2,
                'status' => $request->status,
            ]);
            //create product
            if ($request->hasFile('photo')) {
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/product/photo/' . '/');
                $item->photo()->save($photo);
            }
//            added gallery photos
            if ($request->hasFile('photos')) {
                foreach ($request->photos as $photo) {
                    $gallery = new Photo();
                    $gallery->type = 'gallery';
                    $gallery->path = file_store($photo, 'assets/admin/uploads/product/gallery', '/');
                    $item->gallery()->save($gallery);
                }
            }
            //            added gallery photos
            if ($request->hasFile('photos_mobile')) {
                foreach ($request->photos_mobile as $photo) {
                    $gallery = new Photo();
                    $gallery->type = 'gallery_mobile';
                    $gallery->path = file_store($photo, 'assets/admin/uploads/product/gallery/mobile/', '/');
                    $item->gallery()->save($gallery);
                }
            }

            store_lang($item, $request, ['title', 'text', 'text2', 'status', 'top_text'], 'create');

            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت افزوده شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای افزودن به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    public function edit($id)
    {
        $url_back = $this->controller_title('url_back');
        $cats = ProductCategory::with('childs')
            ->whereNull('parent_id')
            ->orderBy('sort')->get();
        $cats_id=[];
        foreach ($cats as $cat)
        {
            array_push($cats_id,['id'=>$cat->id,'title'=>$cat->title]);
            foreach ($cat->childs as $child)
            {
                array_push($cats_id,['id'=>$child->id,'title'=>$cat->title.' - '.$child->title]);
            }
        }
        $item = Product::findOrFail($id);
        return view('admin.product.edit', compact('url_back', 'item', 'cats_id'), ['title' => $this->controller_title('edit')]);
    }

    public function update(ProductRequest $request, $id)
    {
        $item = Product::findOrFail($id);
        try {
            Product::where('id', $id)->update([
                'category_id' => $request->category_id,
                'title' => $request->title,
                'slug' => $request->slug,
                'top_text' => $request->top_text,
                'text' => $request->text,
                'text2' => $request->text2,
                'status' => $request->status,
            ]);
            //edit product
            if ($request->hasFile('photo')) {
                if ($item->photo) {
                    if (is_file($item->photo->path)) {
                        File::delete($item->photo->path);
                        delete_directory($item->photo->path);
                    }
                    $item->photo->delete();
                }
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/product/photo/' . '/');
                $item->photo()->save($photo);
            }
//            added gallery photos
            if ($request->hasFile('photos')) {
                foreach ($request->photos as $photo) {
                    $gallery = new Photo();
                    $gallery->type = 'gallery';
                    $gallery->path = file_store($photo, 'assets/admin/uploads/product/gallery/'. '/');
                    $item->gallery()->save($gallery);
                }
            }
            //            added gallery photos
            if ($request->hasFile('photos_mobile')) {
                foreach ($request->photos_mobile as $photo) {
                    $gallery = new Photo();
                    $gallery->type = 'gallery_mobile';
                    $gallery->path = file_store($photo, 'assets/admin/uploads/product/gallery/mobile/', '/');
                    $item->gallery()->save($gallery);
                }
            }

            store_lang($item, $request, ['title', 'text','text2', 'status' , 'top_text'], 'edit');
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت ویرایش شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    public function destroy($id)
    {
        $item = Product::findOrFail($id);
        try {
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت حذف شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای حذف به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
    public function attr_list($id,Request $request)
    {
        $url_back = $this->controller_title('url_back');
        if(!isset($request->type))
        {
            return redirect()->back()->with('err_message', 'ابتدا نوع ویژگی را مشخص کنید');
        }
        elseif(!in_array($request->type,['text','icon']))
        {
            return redirect()->back()->with('err_message', 'ابتدا نوع ویژگی را درست مشخص کنید');
        }
        $type=$request->type;
        $item = Product::findOrFail($id);
        $items = ProductAttr::where('product_id',$id)->where('type',$type)->orderBy('sort')->get();
        return view('admin.product.attr.index', compact('url_back', 'items','id','type'), ['title' => $this->controller_title('attr_list') . $item->title]);
    }
    public function attr_store($id,Request $request)
    {
        $item = Product::findOrFail($id);
        if($request->type == 'text')
        {
            $this->validate($request, [
                'title' => 'required|max:200',
                'value' => 'required|max:200',
            ]);
            $title=$request->title;
        }
        else
        {
            $this->validate($request, [
                'icon' => "required|image|mimes:png,webp|max:512",
                'value' => 'required|max:200',
            ]);


            if ($request->hasFile('icon')) {
                $title = file_store($request->icon, 'assets/admin/uploads/product/attr/icon/' . '/');
            }
        }
        try {
            $item = ProductAttr::create([
                'product_id' => $id,
                'title' => $title,
                'type' => $request->type,
                'value' => $request->value,
                'status' => $request->status,
            ]);
            if($request->type == 'text')
                store_lang($item, $request, ['title', 'value', 'status'], 'create');
            else
                store_lang($item, $request, ['value', 'status'], 'create');

            return redirect()->back()->with('flash_message', 'اطلاعات با موفقیت افزوده شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای افزودن به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
    public function attr_destroy($id)
    {
        $item = ProductAttr::findOrFail($id);
        try {
            $item->delete();
            return redirect()->back()->with('flash_message', 'اطلاعات با موفقیت حذف شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای حذف به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    public function attr_sort($id, Request $request)
    {
        $item = ProductAttr::findOrFail($id);
        if((int)$request->sort < 0)
            return redirect()->back()->withInput()->with('err_message', 'برای سورت به مشکل خوردیم، عدد صحیح وارد کنید');
        try {
            $item->sort = (int)$request->sort;
            $item->update();
            return redirect()->back()->with('flash_message', 'اطلاعات با موفقیت سورت شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای سورت به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
}
