<?php

namespace App\Http\Controllers\Admin\Other;

use App\Http\Controllers\Controller;
use App\Http\Requests\Other\ResearchProjectRequest;
use App\Models\Photo;
use App\Models\ResearchProject;
use App\Models\Slider;
use App\Models\User;
use Illuminate\Http\Request;

class ResearchProjectController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return 'پروژه های پژوهشی';
                break;
            case 'create':
                return 'افزودن پروژه';
                break;
            case 'edit':
                return 'ویرایش پروژه';
                break;
            case 'url_back':
                return route('admin.project.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:research_project_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:research_project_create', ['only' => ['create', 'store']]);
        $this->middleware('permission:research_project_edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:research_project_delete', ['only' => ['destroy']]);
        $this->middleware('permission:research_project_status', ['only' => ['status']]);
    }
    public function index()
    {
        $items=ResearchProject::orderBy('sort')->get();
        return view('admin.other.project.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $users=User::role('instructor')->get();
        return view('admin.other.project.create', compact('users'), ['title' => $this->controller_title('create')]);

    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(ResearchProjectRequest $request)
    {
        try {
            $item = ResearchProject::create([
                'title'=>$request->title,
                'description'=>$request->description,
                'user_id'=>$request->user_id,
                'complete'=>$request->complete,
                'sort'=>$request->sort,
            ]);

            if ($request->hasFile('photo')) {
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/other/project' . '/');
                $item->photo()->save($photo);
            }

            store_lang($item, $request, ['title', 'description', 'user_id', 'complete','sort'], 'create');

            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت افزوده شد');
        } catch (\Exception $e) {
           // dd($e->getMessage(), $e->getFile(), $e->getLine());
            return redirect()->back()->withInput()->with('err_message', 'برای افزودن به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $users=User::role('instructor')->get();
        $item = ResearchProject::findOrFail($id);
        return view('admin.other.project.edit', compact('users', 'item'), ['title' => $this->controller_title('edit')]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(ResearchProjectRequest $request, $id)
    {
        $item = ResearchProject::findOrFail($id);
        try {
            ResearchProject::where('id', $id)->update([
                'title'=>$request->title,
                'description'=>$request->description,
                'user_id'=>$request->user_id,
                'complete'=>$request->complete,
                'sort'=>$request->sort,
            ]);
            //edit slider
            if ($request->hasFile('photo')) {
                if ($item->photo) {
                    if (is_file($item->photo->path)) {
                        File::delete($item->photo->path);
                        delete_directory($item->photo->path);
                    }
                    $item->photo->delete();
                }
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/setting/slider' . '/');
                $item->photo()->save($photo);
            }

            store_lang($item, $request, ['title', 'description', 'user_id', 'complete','sort'], 'edit');

            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت ویرایش شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $item = ResearchProject::findOrFail($id);
        try {
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت حذف شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای حذف به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    public function status($id, $type, $status)
    {
        $item = ResearchProject::findOrFail($id);
        try {
            $item->$type = $status;
            $item->update();
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت تغییر وضعیت شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای تغییر وضعیت به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
}
