<?php

namespace App\Http\Controllers\Admin\Other;

use App\Models\CategoryFaq;
use App\Models\Faq;
use App\Http\Requests\Other\FaqRequest;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use otherbon\otherbon;

class FaqController extends Controller
{
    public function controller_title($type)
    {
        switch ($type)
        {
            case 'index':
                return 'سوالات متداول';
                break;
            case 'create':
                return 'افزودن سوالات متداول';
                break;
            case 'edit':
                return 'ویرایش سوالات متداول';
                break;
            case 'url_back':
                return route('admin.faq.index');
                break;
            default:
                return '';
                break;
        }
    }
    public function __construct()
    {
        $this->middleware('permission:faq_list', ['only' => ['index','show']]);
        $this->middleware('permission:faq_create', ['only' => ['create','store']]);
        $this->middleware('permission:faq_edit', ['only' => ['edit','update']]);
        $this->middleware('permission:faq_delete', ['only' => ['destroy']]);
        $this->middleware('permission:faq_status', ['only' => ['status']]);
        $this->middleware('permission:faq_sort', ['only' => ['sort']]);
    }

    public function index()
    {
        $items=Faq::orderBy('sort')->get();
        return view('admin.other.faq.index', compact('items'), ['title' => $this->controller_title('index')]);
    }
    public function show($id)
    {

    }
    public function create()
    {
        $url_back=$this->controller_title('url_back');
        $categories=CategoryFaq::where('parent_id',null)->orderBy('sort')->get();
        return view('admin.other.faq.create',compact(['url_back','categories']), ['title' => $this->controller_title('create')]);
    }
    public function store(FaqRequest $request)
    {
        try {
            $item = Faq::create([
                'category_id'=> $request->category_id,
                'question' => $request->question,
                'answer' => $request->answer,
                'status' => $request->status,
            ]);

            store_lang($item,$request,['question','answer'],'create');

            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت افزوده شد');
        } catch (\Exception $e) {
            dd($e);
            return redirect()->back()->withInput()->with('err_message', 'برای افزودن به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
    public function edit($id)
    {
        $url_back=$this->controller_title('url_back');
        $item=Faq::findOrFail($id);
        $categories=CategoryFaq::where('parent_id',null)->orderBy('sort')->get();
        return view('admin.other.faq.edit',compact(['url_back','item','categories']), ['title' => $this->controller_title('edit')]);
    }
    public function update(FaqRequest $request,$id)
    {
        $item=Faq::findOrFail($id);
        try {
            Faq::where('id',$id)->update([
                'category_id'=> $request->category_id,
                'question' => $request->question,
                'answer' => $request->answer,
                'status' => $request->status,
            ]);
            store_lang($item,$request,['question','answer'],'edit');

            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت ویرایش شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
    public function destroy($id)
    {
        $item=Faq::findOrFail($id);
        try {
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت حذف شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای حذف به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
    public function sort($id,Request $request)
    {
        $item=Faq::findOrFail($id);
        try {
            $item->sort=$request->sort;
            $item->update();
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت سورت شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای سورت به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
    public function status($id,$type, Request $request)
    {
        $item = Faq::findOrFail($id);
        try {
            $item->status_home = $type;
            $item->update();
            return redirect()->back()->with('flash_message', 'اطلاعات با موفقیت تغیر وضعیت شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای تغیر وضعیت به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    public function getChildren(Request $request)
    {
        $children = CategoryFaq::where('parent_id', $request->parent_id)
            ->orderBy('sort')
            ->pluck('title', 'id');

        return response()->json($children);
    }
}
