<?php

namespace App\Http\Controllers\Admin\Other;

use App\Http\Controllers\Controller;
use App\Http\Requests\Other\CertificateRequest;
use App\Models\Certificate;
use App\Models\Photo;
use Illuminate\Support\Facades\File;

class CertificateController extends Controller
{

    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return 'گواهینامه ها';
                break;
            case 'create':
                return 'افزودن گواهینامه';
                break;
            case 'edit':
                return 'ویرایش گواهینامه';
                break;
            case 'url_back':
                return route('admin.certificate.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:certificate_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:certificate_create', ['only' => ['create', 'store']]);
        $this->middleware('permission:certificate_edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:certificate_delete', ['only' => ['destroy']]);
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $items = Certificate::orderByDesc('id')->get();
        return view('admin.other.certificate.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.other.certificate.create', ['title' => $this->controller_title('create')]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(CertificateRequest $request)
    {
        try {
            $item = Certificate::create([
                'title' => $request->title,
                'type' => $request->type,
                'status' => $request->status,
            ]);

            if ($request->hasFile('photo')) {
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/certificates' . '/');
                $item->photo()->save($photo);
            }

            store_lang($item, $request, ['title', 'status'], 'create');

            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت افزوده شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای افزودن به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Certificate $certificate)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Certificate $certificate)
    {
        return view('admin.other.certificate.edit', compact('certificate'), ['title' => $this->controller_title('edit')]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(CertificateRequest $request, Certificate $certificate)
    {
        try {
            $certificate->update([
                'title' => $request->title,
                'type' => $request->type,
                'status' => $request->status,
            ]);

            if ($request->hasFile('photo')) {
                if ($certificate->photo) {
                    if (is_file($certificate->photo->path)) {
                        File::delete($certificate->photo->path);
                        delete_directory($certificate->photo->path);
                    }
                    $certificate->photo->delete();
                }
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/certificates' . '/');
                $certificate->photo()->save($photo);
            }

            store_lang($certificate, $request, ['title', 'status', 'slug'], 'edit');

            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت ویرایش شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Certificate $certificate)
    {
        try {
            $certificate->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت حذف شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای حذف به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
}
