<?php

namespace App\Http\Controllers\Admin\Other;

use App\Http\Controllers\Controller;
use App\Http\Requests\Other\CategoryFaqRequest;
use App\Models\CategoryFaq;
use Illuminate\Http\Request;

class CategoryFaqController extends Controller
{
    public function controller_title($type)
    {
        switch ($type)
        {
            case 'index':
                return ' دسته بندی سوالات متداول';
                break;
            case 'create':
                return 'افزودن دسته سوالات متداول';
                break;
            case 'edit':
                return 'ویرایش دسته سوالات متداول';
                break;
            case 'url_back':
                return route('admin.faq-category.index');
                break;
            default:
                return '';
                break;
        }
    }
    public function __construct()
    {
        $this->middleware('permission:category_faq_list', ['only' => ['index','show']]);
        $this->middleware('permission:category_faq_create', ['only' => ['create','store']]);
        $this->middleware('permission:category_faq_edit', ['only' => ['edit','update']]);
        $this->middleware('permission:category_faq_delete', ['only' => ['destroy']]);
        $this->middleware('permission:category_faq_status', ['only' => ['status']]);
        $this->middleware('permission:category_faq_sort', ['only' => ['sort']]);
    }

    public function index()
    {
        $items=CategoryFaq::whereNull('parent_id')->with('children')->get();
        return view('admin.other.faq.category.index', compact('items'), ['title' => $this->controller_title('index')]);
    }
    public function show($id)
    {

    }
    public function create()
    {
        $url_back=$this->controller_title('url_back');
        $categories=CategoryFaq::where('parent_id',null)->orderBy('sort')->get();
        return view('admin.other.faq.category.create',compact(['url_back','categories']), ['title' => $this->controller_title('create')]);
    }
    public function store(CategoryFaqRequest $request)
    {
        try {
            $item = CategoryFaq::create([
                'parent_id' => $request->parent_id ?: null,
                'title' => $request->title,
                'slug' => $request->slug,
                'status'=>$request->status,
                'icon'=>$request->icon,
            ]);

            store_lang($item,$request,['title','slug','status'],'create');
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت افزوده شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای افزودن به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
    public function edit($id)
    {
        $url_back=$this->controller_title('url_back');
        $item=CategoryFaq::findOrFail($id);
        $categories=CategoryFaq::where('parent_id',null)->orderBy('sort')->get();
        return view('admin.other.faq.category.edit',compact(['url_back','item','categories']), ['title' => $this->controller_title('edit')]);
    }
    public function update(CategoryFaqRequest $request,$id)
    {
        $item=CategoryFaq::findOrFail($id);
        try {
            CategoryFaq::where('id',$id)->update([
                'parent_id' => $request->parent_id,
                'title' => $request->title,
                'slug' => $request->slug,
                'status'=>$request->status,
                'icon'=>$request->icon,
            ]);
            store_lang($item,$request,['title','slug','status'],'edit');

            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت ویرایش شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
    public function destroy($id)
    {
        $item=CategoryFaq::findOrFail($id);
        try {
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت حذف شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای حذف به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
    public function sort($id,Request $request)
    {
        $item=CategoryFaq::findOrFail($id);
        try {
            $item->sort=$request->sort;
            $item->update();
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت سورت شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای سورت به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
    public function status($id,$type, Request $request)
    {
        $item = CategoryFaq::findOrFail($id);
        try {
            $item->status = $type;
            $item->update();
            return redirect()->back()->with('flash_message', 'اطلاعات با موفقیت تغیر وضعیت شد');
        } catch (\Exception $e) {
            dd($e->getMessage());
            //return redirect()->back()->withInput()->with('err_message', 'برای تغیر وضعیت به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
}
