let currentSlide = 0;
const slides = document.querySelectorAll('.hero-slide');
const indicators = document.querySelectorAll('.indicator');
const totalSlides = slides.length;

// Update slides and indicators
function updateSlider() {
    slides.forEach((slide, index) => slide.classList.toggle('active', index === currentSlide));
    indicators.forEach((ind, index) => ind.classList.toggle('active', index === currentSlide));
}

// Next / Prev
function nextSlide() { currentSlide = (currentSlide + 1) % totalSlides; updateSlider(); }
function previousSlide() { currentSlide = (currentSlide - 1 + totalSlides) % totalSlides; updateSlider(); }

// Auto-play
let sliderInterval = setInterval(nextSlide, 5000);

// Indicators click
indicators.forEach((ind, idx) => {
    ind.addEventListener('click', () => {
        currentSlide = idx;
        updateSlider();
        clearInterval(sliderInterval);
        sliderInterval = setInterval(nextSlide, 5000); // Reset autoplay
    });
});

// Controls click
document.querySelector('.hero-nav.next').addEventListener('click', () => { nextSlide(); clearInterval(sliderInterval); sliderInterval = setInterval(nextSlide, 5000); });
document.querySelector('.hero-nav.prev').addEventListener('click', () => { previousSlide(); clearInterval(sliderInterval); sliderInterval = setInterval(nextSlide, 5000); });

// Theme toggle
document.querySelector('.theme-btn').addEventListener('click', () => {
    document.body.classList.toggle('dark-theme');
    localStorage.setItem('darkTheme', document.body.classList.contains('dark-theme'));
});

// Load saved theme
if(localStorage.getItem('darkTheme') === 'true'){ document.body.classList.add('dark-theme'); }

// Initial
updateSlider();
